/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * AppConstants is a set of immutable constants that are defined at build time.
 * These should not depend on any other JavaScript module.
 */
export var AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 19 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 21 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  ENABLE_EXPLICIT_RESOURCE_MANAGEMENT:
//@line 26 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 28 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  RELEASE_OR_BETA:
//@line 31 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 35 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  EARLY_BETA_OR_EARLIER:
//@line 40 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 42 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  IS_ESR:
//@line 47 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 49 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  ACCESSIBILITY:
//@line 52 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 56 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 64 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 66 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_OFFICIAL_BRANDING:
//@line 69 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 73 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_DEV_EDITION:
//@line 78 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 80 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_SERVICES_SYNC:
//@line 85 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 87 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_DATA_REPORTING:
//@line 90 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 94 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_SANDBOX:
//@line 97 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 101 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_TELEMETRY_REPORTING:
//@line 106 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 108 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_UPDATER:
//@line 113 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 115 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_WEBRTC:
//@line 118 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 122 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_WIDGET_GTK:
//@line 127 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 129 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_WMF_CDM:
//@line 132 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 136 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  XP_UNIX:
//@line 141 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 143 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

// NOTE! XP_LINUX has to go after MOZ_WIDGET_ANDROID otherwise Android
// builds will be misidentified as linux.
  platform:
//@line 150 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  "win",
//@line 162 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

// Most of our frontend code assumes that any desktop Unix platform
// is "linux". Add the distinction for code that needs it.
  unixstyle:
//@line 177 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    "other",
//@line 179 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 196 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 198 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_NORMANDY:
//@line 201 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 205 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_MAINTENANCE_SERVICE:
//@line 210 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 212 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_BACKGROUNDTASKS:
//@line 215 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 219 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_UPDATE_AGENT:
//@line 224 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 226 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_BITS_DOWNLOAD:
//@line 229 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 233 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  DEBUG:
//@line 238 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 240 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  ASAN:
//@line 245 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 247 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  ASAN_REPORTER:
//@line 252 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 254 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  TSAN:
//@line 259 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 261 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_SYSTEM_NSS:
//@line 266 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 268 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_PLACES:
//@line 271 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 275 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_REQUIRE_SIGNING:
//@line 278 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 282 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_UNSIGNED_APP_SCOPE:
//@line 287 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 289 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_UNSIGNED_SYSTEM_SCOPE:
//@line 294 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 296 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_ALLOW_ADDON_SIDELOAD:
//@line 301 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 303 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_WEBEXT_WEBIDL_ENABLED:
//@line 308 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 310 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MENUBAR_CAN_AUTOHIDE:
//@line 313 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 317 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_GECKOVIEW_HISTORY:
//@line 322 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  false,
//@line 324 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_GECKO_PROFILER:
//@line 327 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  true,
//@line 331 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  DLL_PREFIX: "",
  DLL_SUFFIX: ".dll",

  MOZ_APP_NAME: "firefox",
  MOZ_APP_BASENAME: "Firefox",
  // N.b.: you almost certainly want brandShortName/brand-short-name:
  // MOZ_APP_DISPLAYNAME should only be used for static user-visible
  // fields (e.g., DLL properties, Mac Bundle name, or similar).
  MOZ_APP_DISPLAYNAME_DO_NOT_USE: "Firefox",
  MOZ_APP_VERSION: "135.0.1",
  MOZ_APP_VERSION_DISPLAY: "135.0.1",
  MOZ_BUILDID: "20251129164849",
  MOZ_BUILD_APP: "browser",
  MOZ_MACBUNDLE_ID: "org.mozilla.firefox",
  MOZ_MACBUNDLE_NAME: "Firefox.app",
  MOZ_UPDATE_CHANNEL: "default",
  MOZ_WIDGET_TOOLKIT: "windows",

  DEBUG_JS_MODULES: "",

  MOZ_BING_API_CLIENTID: "no-bing-api-clientid",
  MOZ_BING_API_KEY: "no-bing-api-key",
  MOZ_GOOGLE_LOCATION_SERVICE_API_KEY: "no-google-location-service-api-key",
  MOZ_GOOGLE_SAFEBROWSING_API_KEY: "no-google-safebrowsing-api-key",
  MOZ_MOZILLA_API_KEY: "no-mozilla-api-key",

  BROWSER_CHROME_URL: "chrome://browser/content/browser.xhtml",

  OMNIJAR_NAME: "omni.ja",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 368 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 374 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    false,
//@line 376 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  HAVE_SHELL_SERVICE:
//@line 379 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    true,
//@line 383 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_CODE_COVERAGE:
//@line 388 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    false,
//@line 390 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  TELEMETRY_PING_FORMAT_VERSION: 4,

  ENABLE_WEBDRIVER:
//@line 395 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    true,
//@line 399 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  REMOTE_SETTINGS_SERVER_URL:
//@line 404 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    "https://firefox.settings.services.mozilla.com/v1",
//@line 406 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  REMOTE_SETTINGS_VERIFY_SIGNATURE:
//@line 411 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    true,
//@line 413 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  REMOTE_SETTINGS_DEFAULT_BUCKET:
//@line 418 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    "main",
//@line 420 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_GLEAN_ANDROID:
//@line 425 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    false,
//@line 427 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_JXL:
//@line 432 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    false,
//@line 434 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

//@line 451 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_SYSTEM_POLICIES:
//@line 454 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    true,
//@line 458 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_SELECTABLE_PROFILES:
//@line 461 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    true,
//@line 465 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  SQLITE_LIBRARY_FILENAME:
//@line 468 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
  "nss3.dll",
//@line 472 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  MOZ_GECKOVIEW:
//@line 477 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"
    false,
//@line 479 "$SRCDIR/toolkit/modules/AppConstants.sys.mjs"

  // Returns true for CN region build when distibution id set as 'MozillaOnline'
  isChinaRepack() {
    return (
      Services.prefs
      .getDefaultBranch("")
      .getCharPref("distribution.id", "default") === "MozillaOnline"
    );
  },
});
